/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.core;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsInstanceOfTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return IsInstanceOf.instanceOf(Number.class);
    }

    public void testEvaluatesToTrueIfArgumentIsInstanceOfASpecificClass() {
        MatcherAssert.assertThat((Object)1, (Matcher)IsInstanceOf.instanceOf(Number.class));
        MatcherAssert.assertThat((Object)1.0, (Matcher)IsInstanceOf.instanceOf(Number.class));
        MatcherAssert.assertThat(null, (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(Number.class)));
        MatcherAssert.assertThat((Object)new Object(), (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(Number.class)));
    }

    public void testHasAReadableDescription() {
        IsInstanceOfTest.assertDescription("an instance of java.lang.Number", IsInstanceOf.instanceOf(Number.class));
    }

    public void testDecribesActualClassInMismatchMessage() {
        IsInstanceOfTest.assertMismatchDescription("\"some text\" is a java.lang.String", IsInstanceOf.instanceOf(Number.class), "some text");
    }

    public void testMatchesPrimitiveTypes() {
        MatcherAssert.assertThat((Object)true, (Matcher)IsInstanceOf.any(Boolean.TYPE));
        MatcherAssert.assertThat((Object)1, (Matcher)IsInstanceOf.any(Byte.TYPE));
        MatcherAssert.assertThat((Object)Character.valueOf('x'), (Matcher)IsInstanceOf.any(Character.TYPE));
        MatcherAssert.assertThat((Object)5.0, (Matcher)IsInstanceOf.any(Double.TYPE));
        MatcherAssert.assertThat((Object)Float.valueOf(5.0f), (Matcher)IsInstanceOf.any(Float.TYPE));
        MatcherAssert.assertThat((Object)2, (Matcher)IsInstanceOf.any(Integer.TYPE));
        MatcherAssert.assertThat((Object)4L, (Matcher)IsInstanceOf.any(Long.TYPE));
        MatcherAssert.assertThat((Object)1, (Matcher)IsInstanceOf.any(Short.TYPE));
    }

    public void testInstanceOfRequiresACastToReturnTheCorrectTypeForUseInJMock() {
        Integer anInteger = (Integer)IsInstanceOfTest.with(IsInstanceOf.instanceOf(Integer.class));
    }

    public void testAnyWillReturnTheCorrectTypeForUseInJMock() {
        Integer anInteger = (Integer)IsInstanceOfTest.with(IsInstanceOf.any(Integer.class));
    }

    private static <T> T with(Matcher<T> matcher) {
        return null;
    }
}

